﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Web.Security.AntiXss;

public partial class LabKitDetails : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabKitInProcessOrders.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly LabKitOrderManager _labKitOrderManager;

    private WKF_CASE_ACTIVITY _activity;
    private PATIENT _patient;
    private WKF_CASE _wCase;
    protected STD_WKFACTIVITYST _activitySt;

    public LabKitDetails()
    {
        _labKitOrderManager = new LabKitOrderManager();

        //Manager Save Notification Event Handler
        _labKitOrderManager.BOSaveSuccess += manager_BOSaveSuccess;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int WKFCaseActivityId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["ActivityId"], false));
            BindData(WKFCaseActivityId, false);

            SetReferringPage();
        }
    }

    void Page_PreRender(object sender, EventArgs e)
    {

        KitOrderedDateCompareValidator.ValueToCompare = DateTime.Today.AddYears(100).ToShortDateString();
        KitSentCompareValidator.ValueToCompare = DateTime.Today.AddYears(100).ToShortDateString();
        KitReceivedDateCompareValidator.ValueToCompare = DateTime.Today.AddYears(100).ToShortDateString();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        _wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
        _activity = _wCase.WKF_CASE_ACTIVITies[0];
        _activity.KIT_ORDER_DATE = Helpers.ToNullable<DateTime>(KitOrderedDate.Text.Trim()); //TODO - Add a new field to db tanle and use it
        _activity.KIT_USE_STOCK_FLAG = LabelOrderedFromStock.Text == "Yes";
        _activity.REPRESENTATIVE_NAME = lblTEFSCRep.Text;
        _activity.CONTACT_NAME = txtVAMCRep.Text;
        _activity.ADDRESS_LINE1 = txtAddressPart1.Text;
        _activity.ADDRESS_LINE2 = txtAddressPart2.Text;
        _activity.ADDRESS_LINE3 = txtAddressPart3.Text;
        _activity.STATE = txtState.Text;
        _activity.CITY = txtCity.Text;
        _activity.POSTAL_CODE = txtZip.Text;
        _activity.COUNTRY = txtCountry.Text;
        _activity.CONTACT_PHONE = txtPhone.Text;
        _activity.SetAsChangeTrackingRoot(true);

        //Save ship details
        SHIPPING_DETAIL ship = null;
        if (_activity.SHIPPING_DETAILs.Count() != 0)
        {   //Already exists
            ship = _activity.SHIPPING_DETAILs[0];
            _activity.SetAsUpdateOnSubmit(true);
        }
        else
        {
            ship = new SHIPPING_DETAIL();
            _activity.SHIPPING_DETAILs.Add(ship);
            ship.SetAsChangeTrackingRoot(EntityState.New, true);
            ship.SetAsInsertOnSubmit();
            _activity.SetAsUpdateOnSubmit();
        }

        ship.STD_REGISTRY_ID = _labKitOrderManager.UserMgr.RegistryId;
        ship.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;

        if (int.Parse(DDLShippingStatus.SelectedValue) > 0)
        {
            ship.STD_SHIPMENTSTS_ID = Helpers.ToNullable<int>(DDLShippingStatus.SelectedValue);
        }
        ship.REPRESENTATIVE_NAME = txtRetVAMCContact.Text;
        ship.TRACKING_NUMBER = txtRetCourierNumber.Text;
        ship.SEND_DATE = Helpers.ToNullable<DateTime>(KitSentDate.Text);

        //Client side script changing the value to null. But does not work. 
        if (ship.STD_SHIPMENTSTS_ID != null)
            KitReceivedDate.Text = "";
        ship.RECEIVED_DATE = Helpers.ToNullable<DateTime>(KitReceivedDate.Text);
        ship.SURVEY_RECEIVED_FLAG = (int.Parse(radQstnrReceived.SelectedValue) == 1);

        //Two entities- ship and activity
        if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) 
            || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.KitLost) 
            || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) ship.COMMENT_TEXT = txtRetOther.Text;

        if (_activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Voided)
        {
            _activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Tracking);
            ship.STD_SHIPMENTSTS_ID = null;
            ship.COMMENT_TEXT = String.Empty;
        }

        //don't initiate any activities here
        OpenCloseReferralAndWorkflowCase(_wCase, () => "Save");

        if (_activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Received && int.Parse(radQstnrReceived.SelectedValue) == 1)
        {
            _labKitOrderManager.UpdateKitActivity(_wCase, () => true);
        }
        else
        {
            _labKitOrderManager.UpdateKitActivity(_wCase, () => false);
        }

        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        BindData(_activity.WKF_CASE_ACTIVITY_ID, true);
    }

    private void BindData(int wkfCaseActivityId, bool resetReason)
    {
        CityStateManager addressManager = new CityStateManager();

        _wCase = _labKitOrderManager.KitOrderDetails(wkfCaseActivityId);
        _patient = _wCase.REFERRAL.PATIENT;
        //TODO - Check the default value
        _activity = _wCase.WKF_CASE_ACTIVITies[0];
        ViewState["WCase"] = _wCase.Serialize();
        if (_activity != null)
        {
            lblCaseId.Text = _activity.WKF_CASE_ID.ToString();
            LabelPatientName.Text = _patient.FullName;
            if (_activity.KIT_ORDER_DATE.HasValue)
                KitOrderedDate.Text = _activity.KIT_ORDER_DATE.Value.ToShortDateString();

            LabelOrderedFromStock.Text = _activity.KIT_USE_STOCK_FLAG.HasValue ? _activity.KIT_USE_STOCK_FLAG.Value.ToString().Replace("True", "Yes").Replace("False", "No") : "No";

            lblTEFSCRep.Text = _activity.REPRESENTATIVE_NAME;
            txtVAMCRep.Text = _activity.CONTACT_NAME;

            if (String.IsNullOrEmpty(_activity.ADDRESS_LINE1))
            {
                if (String.IsNullOrEmpty(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1))
                {
                    txtAddressPart1.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE1;
                    txtAddressPart2.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE2;
                    txtAddressPart3.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE3;
                    txtCity.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCITY;
                    txtZip.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETPOSTALCODE;
                    if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETSTATE_ID.HasValue)
                    {
                        txtState.Text = DropDownLists.ConvertNullToEmptyString(addressManager.GetStateByID(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETSTATE_ID.GetValueOrDefault()));
                    }

                    if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCOUNTRY_ID.HasValue)
                    {
                        txtCountry.Text = DropDownLists.ConvertNullToEmptyString(addressManager.GetCountryByID(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCOUNTRY_ID.GetValueOrDefault()));
                    }
                }
                else
                {
                    txtAddressPart1.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1;
                    txtAddressPart2.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE2;
                    txtAddressPart3.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE3;
                    txtCity.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCITY;
                    txtZip.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE;
                    if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID.HasValue)
                    {
                        txtState.Text = DropDownLists.ConvertNullToEmptyString(addressManager.GetStateByID(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID.GetValueOrDefault()));
                    }

                    if (_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCOUNTRY_ID.HasValue)
                    {
                        txtCountry.Text = DropDownLists.ConvertNullToEmptyString(addressManager.GetCountryByID(_activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCOUNTRY_ID.GetValueOrDefault()));
                    }
                }
            }
            else
            {
                txtAddressPart1.Text = _activity.ADDRESS_LINE1;
                txtAddressPart2.Text = _activity.ADDRESS_LINE2;
                txtAddressPart3.Text = _activity.ADDRESS_LINE3;
                txtState.Text = _activity.STATE;
                txtCity.Text = _activity.CITY;
                txtZip.Text = _activity.POSTAL_CODE;
                txtCountry.Text = _activity.COUNTRY;
            }

            txtPhone.Text = _activity.CONTACT_PHONE;
            lblKitType.Text = _activity.WKF_CASE.STD_WKFCASETYPE.CODE;
            _activitySt = _activity.STD_WKFACTIVITYST;

            if (_activitySt.ID == Convert.ToInt16(WorkflowCaseActivityStatus.Voided))
                MakeControlsReadOnly(this.Controls);
            else
                MakeControlsWriteable(this.Controls);

            //This is not updatable. It is maintained in REFERRAL
            lblRetPhoneNumber.Text = _activity.WKF_CASE.REFERRAL.VAMC_CONTACT_PHONE;
            lblRetVAMCFacility.Text = _activity.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME;
            //This is not editable. Not maintained in _activity or shipping tables
            lblKitType.Text = _activity.WKF_CASE.STD_WKFCASETYPE.CODE;
            if (lblKitType.Text.ToUpper() == "FRAGMENT ANALYSIS")
            {
                lblFormType.Text = "Fragment Collection Form Received";
                lblFormType.AssociatedControlID = radQstnrReceived.ID;
            }
            if (DDLShippingStatus.Items.Count <= 1)
                DDLShippingStatus.Items.AddRange(DropDownLists.GetShippingStatus().Select(t => new ListItem(t.Value, t.Key.ToString())).ToArray());

            if (_activity.SHIPPING_DETAILs.Count() == 0)
            {
                //Store the order type 
                ViewState["OrderType"] = _activitySt.ID;
                txtRetVAMCContact.Text = _activity.WKF_CASE.REFERRAL.VAMC_CONTACT_NAME;
            }
            else
            {
                //Store the order type 
                ViewState["OrderType"] = _activitySt.ID;

                txtRetVAMCContact.Text = _activity.SHIPPING_DETAILs[0].REPRESENTATIVE_NAME;
                txtRetCourierNumber.Text = _activity.SHIPPING_DETAILs[0].TRACKING_NUMBER;
                KitSentDate.Text = (_activity.SHIPPING_DETAILs[0].SEND_DATE.HasValue ? _activity.SHIPPING_DETAILs[0].SEND_DATE.GetValueOrDefault().ToShortDateString() : "");

                KitReceivedDate.Text = (_activity.SHIPPING_DETAILs[0].RECEIVED_DATE.HasValue ? _activity.SHIPPING_DETAILs[0].RECEIVED_DATE.GetValueOrDefault().ToShortDateString() : "");

                radQstnrReceived.SelectedValue = _activity.SHIPPING_DETAILs[0].SURVEY_RECEIVED_FLAG ? "1" : "0";

                if (resetReason)
                {
                    DDLShippingStatus.SelectedValue = "0";
                    txtRetOther.Text = String.Empty;
                }
                else
                {
                    if (_activity.SHIPPING_DETAILs[0].STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || _activity.SHIPPING_DETAILs[0].STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) //Todo - use enum
                    {
                        DDLShippingStatus.SelectedValue = (_activity.SHIPPING_DETAILs.First().STD_SHIPMENTSTS_ID ?? 0).ToString();
                        txtRetOther.Text = _activity.SHIPPING_DETAILs[0].COMMENT_TEXT;
                        KitReceivedDate.Enabled = false;
                    }
                }
            }
        }

        SetUpButtons(_activity);

        LabKitWorkflowStatus.Value = _activity.STD_WKFACTIVITYSTS_ID.ToString();

        BreadCrumbLabel.Text = "My Tasks > Lab kits > " + _activitySt.NAME.Replace("ORDERED", "TRACKING") + " > Workflow ID " + _wCase.WKF_CASE_ID;
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    private void SetUpButtons(WKF_CASE_ACTIVITY activity)
    {
        switch (activity.STD_WKFACTIVITYSTS_ID)
        {
            case (int)WorkflowCaseActivityStatus.Tracking:

                KitReceivedDateRequiredValidator.IsValid = ShippingStatusValidator.IsValid = true;
                KitReceivedDateRequiredValidator.Enabled = ShippingStatusValidator.Enabled = true;

                BtnVoid.Enabled = BtnReceive.Enabled = true;
                BtnSave.Text = "Save";
                DDLShippingStatus.Enabled = true;
                txtRetOther.Enabled = true;
                break;

            case (int)WorkflowCaseActivityStatus.Voided:

                ShippingStatusValidator.Enabled = KitReceivedDateRequiredValidator.Enabled = false;
                BtnVoid.Enabled = BtnReceive.Enabled = false;
                BtnSave.Text = "Un-Void";
                DDLShippingStatus.Enabled = false;
                txtRetOther.Enabled = false;
                break;

            case (int)WorkflowCaseActivityStatus.Received:

                KitReceivedDateRequiredValidator.IsValid = true;
                KitReceivedDateRequiredValidator.Enabled = true;
                ShippingStatusValidator.Enabled = false;
                BtnVoid.Enabled = BtnReceive.Enabled = false;
                BtnSave.Text = "Save";
                DDLShippingStatus.Enabled = false;
                txtRetOther.Enabled = false;

                break;

            default:

                BtnVoid.Enabled = BtnReceive.Enabled = true;
                BtnSave.Text = "Save";
                break;

        }

    }

    protected void btnReceive_Click(object sender, EventArgs e)
    {
        _wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
        _activity = _wCase.WKF_CASE_ACTIVITies[0];
        _activity.KIT_ORDER_DATE = Helpers.ToNullable<DateTime>(KitOrderedDate.Text.Trim()); //TODO - Add a new field to db tanle and use it
        _activity.KIT_USE_STOCK_FLAG = LabelOrderedFromStock.Text == "Yes";
        _activity.REPRESENTATIVE_NAME = lblTEFSCRep.Text;
        _activity.CONTACT_NAME = txtVAMCRep.Text;
        _activity.ADDRESS_LINE1 = txtAddressPart1.Text;
        _activity.ADDRESS_LINE2 = txtAddressPart2.Text;
        _activity.ADDRESS_LINE3 = txtAddressPart3.Text;
        _activity.STATE = txtState.Text;
        _activity.CITY = txtCity.Text;
        _activity.POSTAL_CODE = txtZip.Text;
        _activity.COUNTRY = txtCountry.Text;
        _activity.CONTACT_PHONE = txtPhone.Text;
        _activity.SetAsChangeTrackingRoot(true);
        //Save ship details
        SHIPPING_DETAIL ship = null;
        if (_activity.SHIPPING_DETAILs.Count() != 0)
        {   //Already exists
            ship = _activity.SHIPPING_DETAILs[0];
            _activity.SetAsUpdateOnSubmit(true);
        }
        else
        {
            ship = new SHIPPING_DETAIL();
            _activity.SHIPPING_DETAILs.Add(ship);
            ship.SetAsChangeTrackingRoot(EntityState.New, true);
            ship.SetAsInsertOnSubmit();
            _activity.SetAsUpdateOnSubmit();
        }

        ship.STD_REGISTRY_ID = _labKitOrderManager.UserMgr.RegistryId;
        ship.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;

        if (int.Parse(DDLShippingStatus.SelectedValue) > 0)
        {
            ship.STD_SHIPMENTSTS_ID = Helpers.ToNullable<int>(DDLShippingStatus.SelectedValue);
        }
        ship.REPRESENTATIVE_NAME = txtRetVAMCContact.Text;
        ship.TRACKING_NUMBER = txtRetCourierNumber.Text;
        ship.SEND_DATE = Helpers.ToNullable<DateTime>(KitSentDate.Text);
        //Client side script changing the value to null. But does not work. 
        if (ship.STD_SHIPMENTSTS_ID != null)
            KitReceivedDate.Text = "";
        ship.RECEIVED_DATE = Helpers.ToNullable<DateTime>(KitReceivedDate.Text);
        ship.SURVEY_RECEIVED_FLAG = (int.Parse(radQstnrReceived.SelectedValue) == 1);
        //Two entities- ship and activity
        if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.KitLost) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) ship.COMMENT_TEXT = txtRetOther.Text;

        _activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Received);

        OpenCloseReferralAndWorkflowCase(_wCase, () => "Receive");

        _labKitOrderManager.UpdateKitActivity(_wCase, () => true);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        BindData(_activity.WKF_CASE_ACTIVITY_ID, false);

    }

    protected void btnVoid_Click(object sender, EventArgs e)
    {
        _wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
        _activity = _wCase.WKF_CASE_ACTIVITies[0];
        _activity.KIT_ORDER_DATE = Helpers.ToNullable<DateTime>(KitOrderedDate.Text.Trim()); //TODO - Add a new field to db tanle and use it
        _activity.KIT_USE_STOCK_FLAG = LabelOrderedFromStock.Text == "Yes";
        _activity.REPRESENTATIVE_NAME = lblTEFSCRep.Text;
        _activity.CONTACT_NAME = txtVAMCRep.Text;
        _activity.ADDRESS_LINE1 = txtAddressPart1.Text;
        _activity.ADDRESS_LINE2 = txtAddressPart2.Text;
        _activity.ADDRESS_LINE3 = txtAddressPart3.Text;
        _activity.STATE = txtState.Text;
        _activity.CITY = txtCity.Text;
        _activity.POSTAL_CODE = txtZip.Text;
        _activity.COUNTRY = txtCountry.Text;
        _activity.CONTACT_PHONE = txtPhone.Text;
        _activity.SetAsChangeTrackingRoot(true);
        //Save ship details
        SHIPPING_DETAIL ship = null;
        if (_activity.SHIPPING_DETAILs.Count() != 0)
        {   //Already exists
            ship = _activity.SHIPPING_DETAILs[0];
            _activity.SetAsUpdateOnSubmit(true);
        }
        else
        {
            ship = new SHIPPING_DETAIL();
            _activity.SHIPPING_DETAILs.Add(ship);
            ship.SetAsChangeTrackingRoot(EntityState.New, true);
            ship.SetAsInsertOnSubmit();
            _activity.SetAsUpdateOnSubmit();
        }

        ship.STD_REGISTRY_ID = _labKitOrderManager.UserMgr.RegistryId;
        ship.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;

        if (int.Parse(DDLShippingStatus.SelectedValue) > 0)
        {
            ship.STD_SHIPMENTSTS_ID = Helpers.ToNullable<int>(DDLShippingStatus.SelectedValue);
        }
        ship.REPRESENTATIVE_NAME = txtRetVAMCContact.Text;
        ship.TRACKING_NUMBER = txtRetCourierNumber.Text;
        ship.SEND_DATE = Helpers.ToNullable<DateTime>(KitSentDate.Text);
        //Client side script changing the value to null. But does not work. 
        if (ship.STD_SHIPMENTSTS_ID != null)
            KitReceivedDate.Text = "";
        ship.RECEIVED_DATE = Helpers.ToNullable<DateTime>(KitReceivedDate.Text);
        ship.SURVEY_RECEIVED_FLAG = (int.Parse(radQstnrReceived.SelectedValue) == 1);
        //Two entities- ship and activity
        if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.KitLost) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) ship.COMMENT_TEXT = txtRetOther.Text;

        _activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Voided);

        OpenCloseReferralAndWorkflowCase(_wCase, () => "Void");

        _labKitOrderManager.UpdateKitActivity(_wCase, () => false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        BindData(_activity.WKF_CASE_ACTIVITY_ID, false);
    }

    protected void btnSimulate_Click(object sender, EventArgs e)
    {
        _wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
        if (_wCase.STD_WKFCASETYPE_ID == Convert.ToInt16(WorkFlowTypes.Biomonitoring))
        {
            _labKitOrderManager.SimulateLabResults(_wCase.WKF_CASE_ID);
        }
    }


    private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
    {
        ReferralManager rm = new ReferralManager();

        EFR_REFERRAL parentReferral = rm.getReferralByReferralID(parentCase.REFERRAL_ID.Value);

        parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
        parentReferral.SetAsChangeTrackingRoot();

        if (operation() == "Void")
        {
            var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

            if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)
                parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;

            parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
        }
        else
        {
            if (parentReferral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;

            if (parentCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;
        }

        SuppressSaveSuccessMessage = true;
        rm.Update(parentReferral);

        SuppressSaveSuccessMessage = false;

    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabKitOrders";
    }

    public override string AppObjectCode()
    {
        return "LabKitOrders";
    }

    protected string SetBreadCrumb()
    {
        return $"My Tasks > Lab kits > {_activitySt.NAME.Replace("Ordered", "Tracking")} > Workflow ID {_wCase.WKF_CASE_ID}";

    }
}
